#version 150

#moj_import <minecraft:fog.glsl>
#moj_import <minecraft:dynamictransforms.glsl>
#moj_import <minecraft:projection.glsl>
#moj_import <minecraft:globals.glsl> 

precision highp float;






#define hue(v)  ((.6+.6*cos(6.*(v)+vec4(0, 23, 21, 1)))+vec4(0., 0., 0., 1.) )

#define finalize() { \
    vertexDistance=length((ModelViewMat*vertex).xyz); \
    texCoord0=UV0; \
}

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV2;


uniform sampler2D Sampler0;

uniform sampler2D Sampler2;

out float vertexDistance;
out vec4 vertexColor;
out vec2 texCoord0;

out float sphericalVertexDistance;
out float cylindricalVertexDistance;

float safeGameTime() {
    float gameTime=GameTime;
    
    if(gameTime <= 0) {
        gameTime=.5;
    }
    return gameTime;
}

float scaledTime() {
    return safeGameTime()*12000.;
}

void f_3090cb41(inout vec4 vertex) {
    gl_Position=ProjMat*ModelViewMat*vertex;
}

void f_78b4587a() {
    vertexColor=Color*texelFetch(Sampler2, UV2 / 16, 0);
}


void f_635d93f9(inout vec4 vertex) {
    f_3090cb41(vertex);
    if(Position.z==0. && gl_Position.x > .95) {
        vertexColor=vec4(0);
    }else{
        f_78b4587a();
    }
    finalize();
}



void f_33a93e00() {
    vertexColor=hue(gl_Position.x+safeGameTime()*1000.)*texelFetch(Sampler2, UV2 / 16, 0);
}

void f_98179974() {
    gl_Position.y+=sin(scaledTime()+(gl_Position.x*6)) / 150.;
}

void f_8eb44fee(inout vec4 vertex) {
    f_3090cb41(vertex);
    f_33a93e00();
    finalize();
}

void f_2539d20c(inout vec4 vertex) {
    f_3090cb41(vertex);
    f_78b4587a();
    f_98179974();
    finalize();
}

void f_09216870(inout vec4 vertex) {
    f_3090cb41(vertex);
    f_98179974();
    f_33a93e00();
    finalize();
}

void f_b71c4141(inout vec4 vertex) {
    f_78b4587a();
    float vertexId=mod(gl_VertexID, 4.);
    if(vertex.z <= 0.) {
        if(vertexId==3. || vertexId==0.) {
            vertex.y+=cos(scaledTime() / 4)*.1;
            vertex.y+=max(cos(scaledTime() / 4)*.1, 0.);
        }
    }else{
        if(vertexId==3. || vertexId==0.) {
            vertex.y-=cos(scaledTime() / 4)*3;
            vertex.y-=max(cos(scaledTime() / 4)*4, 0.);
        }
    }
    f_3090cb41(vertex);
    finalize();
}

void f_7afd42b0(inout vec4 vertex) {
    float vertexId=mod(gl_VertexID, 4.);
    if(vertex.z <= 0.) {
        if(vertexId==3. || vertexId==0.) {
            vertex.y+=cos(scaledTime() / 4)*.1;
            vertex.y+=max(cos(scaledTime() / 4)*.1, 0.);
        }
    }else{
        if(vertexId==3. || vertexId==0.) {
            vertex.y-=cos(scaledTime() / 4)*3;
            vertex.y-=max(cos(scaledTime() / 4)*4, 0.);
        }
    }
    f_33a93e00();
    f_3090cb41(vertex);
    finalize();
}

void f_7c3f4133(inout vec4 vertex, float speed) {
    f_3090cb41(vertex);
    float blink=abs(sin(scaledTime()*speed));
    vertexColor=Color*blink*texelFetch(Sampler2, UV2 / 16, 0);
    finalize();
}



void f_8d66a4d3(inout vec4 vertex) {
    f_3090cb41(vertex);
    f_78b4587a();
    vertexColor=vec4(1, 1, 1, vertexColor.a); 
    finalize();
}


void main() {

    sphericalVertexDistance=fog_spherical_distance(Position);
    cylindricalVertexDistance=fog_cylindrical_distance(Position);
    vertexColor=Color*texelFetch(Sampler2, UV2 / 16, 0);

    vec4 vertex=vec4(Position, 1.);
    ivec3 iColor=ivec3(Color.xyz*255+vec3(.5));

    
    
    if(iColor==ivec3(255, 85, 85))
    {
        f_635d93f9(vertex);
        return;
    }
    

    
    if(fract(Position.z) < .1) {
        
        
        if(iColor==ivec3(19, 23, 9))
        {
            gl_Position=vec4(2, 2, 2, 1);
            f_78b4587a();
            finalize();
            return;
        }
        

        
        
        if(iColor==ivec3(57, 63, 63)) {
            
            
            f_3090cb41(vertex);
            f_78b4587a();
            finalize();
            return;
        }

        
        if(iColor==ivec3(57, 63, 62)) {
            f_2539d20c(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 62, 63)) {
            
            f_2539d20c(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 62, 62)) {
            f_b71c4141(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 61, 63)) {
            f_b71c4141(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 61, 62)) {
            f_7c3f4133(vertex, .5);
            return;
        }

        

        
    }

    
    
    if(iColor==ivec3(78, 92, 36))
    {
        f_8d66a4d3(vertex);
        return;
    }
    

    
    
    
    if(iColor==ivec3(230, 255, 254))
    {
        f_8eb44fee(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 255, 250))
    {
        f_2539d20c(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 251, 254))
    {
        f_09216870(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 251, 250))
    {
        f_b71c4141(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 247, 254))
    {
        f_7afd42b0(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 247, 250))
    {
        f_7c3f4133(vertex, .5);
        return;
    }

    
    

    
    
    
    if(iColor==ivec3(255, 255, 254))
    {
        f_8eb44fee(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 253))
    {
        f_2539d20c(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 25))
    {
        f_09216870(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 251))
    {
        f_b71c4141(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 254, 254))
    {
        f_7afd42b0(vertex);
        return;
    }
    

    
    f_3090cb41(vertex);
    f_78b4587a();
    finalize();
}